#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text.RegularExpressions;
using System.Globalization;

using System.Windows.Forms;

using gov.va.med.vbecs.BOL;

#endregion

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/21/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>
	public class DlgModifyReturnCredit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
        private ListViewItem _lvi;
        private BOL.OutgoingShipmentCollection.LineItem _lineItem;
        //
		#region Form Variables

        private System.Windows.Forms.GroupBox groupBox1;
        private System.Windows.Forms.Button btnOK;
        private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.TextBox txtUnitId;
        private System.Windows.Forms.GroupBox groupBox2;
        private System.Windows.Forms.PictureBox pictureBox1;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.TextBox txtUnitCost;
        private System.Windows.Forms.TextBox txtSpclTesting;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updReturnCredit;
		private System.ComponentModel.IContainer components = null;

		#endregion
        //
		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgModifyReturnCredit));
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.updReturnCredit = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.txtSpclTesting = new System.Windows.Forms.TextBox();
			this.txtUnitCost = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.txtUnitId = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.groupBox1.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updReturnCredit)).BeginInit();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(354, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Modify Return Credit";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 173);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// groupBox1
			// 
			this.groupBox1.AccessibleDescription = "Unit Financials";
			this.groupBox1.AccessibleName = "Unit Financials";
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.updReturnCredit);
			this.groupBox1.Controls.Add(this.label8);
			this.groupBox1.Controls.Add(this.label7);
			this.groupBox1.Controls.Add(this.label6);
			this.groupBox1.Controls.Add(this.txtSpclTesting);
			this.groupBox1.Controls.Add(this.txtUnitCost);
			this.groupBox1.Controls.Add(this.label4);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.txtUnitId);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Location = new System.Drawing.Point(60, 30);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(292, 122);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Unit Financials";
			// 
			// updReturnCredit
			// 
			this.updReturnCredit.AccessibleDescription = "Return Credit Amount";
			this.updReturnCredit.AccessibleName = "Return Credit Amount";
			this.updReturnCredit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updReturnCredit.DecimalPlaces = 2;
			this.updReturnCredit.Location = new System.Drawing.Point(140, 92);
			this.updReturnCredit.Maximum = new System.Decimal(new int[] {
																			999,
																			0,
																			0,
																			0});
			this.updReturnCredit.Name = "updReturnCredit";
			this.updReturnCredit.Size = new System.Drawing.Size(128, 20);
			this.updReturnCredit.TabIndex = 3;
			this.updReturnCredit.Value = new System.Decimal(new int[] {
																		  0,
																		  0,
																		  0,
																		  0});
			this.updReturnCredit.TextChanged += new System.EventHandler(this.updReturnCredit_ValueChanged);
			this.updReturnCredit.Leave += new System.EventHandler(this.updReturnCredit_Leave);
			this.updReturnCredit.ValueChanged += new System.EventHandler(this.updReturnCredit_ValueChanged);
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(128, 92);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(12, 20);
			this.label8.TabIndex = 9;
			this.label8.Text = "$";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(128, 68);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(12, 20);
			this.label7.TabIndex = 6;
			this.label7.Text = "$";
			this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(128, 44);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(12, 20);
			this.label6.TabIndex = 3;
			this.label6.Text = "$";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSpclTesting
			// 
			this.txtSpclTesting.AccessibleDescription = "Special Testing Cost";
			this.txtSpclTesting.AccessibleName = "Special Testing Cost";
			this.txtSpclTesting.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpclTesting.Location = new System.Drawing.Point(140, 68);
			this.txtSpclTesting.Name = "txtSpclTesting";
			this.txtSpclTesting.ReadOnly = true;
			this.txtSpclTesting.Size = new System.Drawing.Size(128, 20);
			this.txtSpclTesting.TabIndex = 2;
			this.txtSpclTesting.Text = "";
			// 
			// txtUnitCost
			// 
			this.txtUnitCost.AccessibleDescription = "Unit Cost";
			this.txtUnitCost.AccessibleName = "Unit Cost";
			this.txtUnitCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitCost.Location = new System.Drawing.Point(140, 44);
			this.txtUnitCost.Name = "txtUnitCost";
			this.txtUnitCost.ReadOnly = true;
			this.txtUnitCost.Size = new System.Drawing.Size(128, 20);
			this.txtUnitCost.TabIndex = 1;
			this.txtUnitCost.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 68);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(118, 20);
			this.label4.TabIndex = 5;
			this.label4.Text = "Special Testing Cost";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 44);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(118, 20);
			this.label3.TabIndex = 2;
			this.label3.Text = "Unit Cost";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 92);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(118, 20);
			this.label2.TabIndex = 8;
			this.label2.Text = "Return Credit Amount*";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtUnitId
			// 
			this.txtUnitId.AccessibleDescription = "Unit I D";
			this.txtUnitId.AccessibleName = "Unit I D";
			this.txtUnitId.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitId.Location = new System.Drawing.Point(140, 20);
			this.txtUnitId.Name = "txtUnitId";
			this.txtUnitId.ReadOnly = true;
			this.txtUnitId.Size = new System.Drawing.Size(128, 20);
			this.txtUnitId.TabIndex = 0;
			this.txtUnitId.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 20);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(118, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "Unit ID";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Enabled = false;
			this.btnOK.Location = new System.Drawing.Point(196, 156);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 4;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(276, 156);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "&Cancel";
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox2.Controls.Add(this.pictureBox1);
			this.groupBox2.Location = new System.Drawing.Point(4, 32);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(52, 120);
			this.groupBox2.TabIndex = 4;
			this.groupBox2.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// DlgModifyReturnCredit
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(354, 189);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.groupBox1);
			this.hlphelpChm.SetHelpKeyword(this, "Outgoing_Shipment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(362, 216);
			this.Name = "DlgModifyReturnCredit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Return Credit";
			this.Load += new System.EventHandler(this.DlgModifyReturnCredit_Load);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.groupBox2, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.groupBox1.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updReturnCredit)).EndInit();
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion 
		//
		#region Constructor / Destructor 

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="lvi"></param>
		public DlgModifyReturnCredit(ListViewItem lvi)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC011.DlgModifyReturnCredit());
			//
			_lvi = lvi;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

        /// <summary>
        /// Initialize the intersting fields.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DlgModifyReturnCredit_Load(object sender, System.EventArgs e)
        {
            string unitCost;
            string specialTestingCost;
            if (_lvi.Tag != null) 
            {
                _lineItem = (BOL.OutgoingShipmentCollection.LineItem)_lvi.Tag;
            }
            else
            {
                GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.RequiredDataNotPresentInSelectedItem());
                this.Close();
                return;
            }
            //
            decimal itemUnitCost = _lineItem.BloodUnitFinance.UnitCost == System.Decimal.MinValue ? 0.0m : _lineItem.BloodUnitFinance.UnitCost;
            decimal itemSpecialTestingCost = _lineItem.BloodUnitFinance.SpecialTestingCost == System.Decimal.MinValue ? 0.0m : _lineItem.BloodUnitFinance.SpecialTestingCost;
            decimal itemReturnCreditAmount = _lineItem.BloodUnitFinance.ReturnCreditAmount == System.Decimal.MinValue ? 0.0m : _lineItem.BloodUnitFinance.ReturnCreditAmount;
            //
            NumberFormatInfo ninf = new NumberFormatInfo();
            ninf.NumberGroupSeparator = "";
            ninf.NumberDecimalDigits = 2;
            if ( itemUnitCost == 0.0m )
            {
                unitCost = "";
            }
            else
            {
                unitCost = itemUnitCost.ToString("n");
            }
            if ( itemSpecialTestingCost == 0.0m )
            {
                specialTestingCost = "";
            }
            else
            {
                specialTestingCost = itemSpecialTestingCost.ToString("n");
            }
			//
            txtUnitId.Text = _lineItem.EyeReadableUnitId;
            txtUnitCost.Text = unitCost;
            txtSpclTesting.Text = specialTestingCost;
			updReturnCredit.Value = itemReturnCreditAmount;
        }

        /// <summary>
        /// Process the user's o-k click.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnOK_Click(object sender, System.EventArgs e)
        {
            _lineItem.BloodUnitFinance.ReturnCreditAmount = this.updReturnCredit.Value;
            _lvi.SubItems[11].Text = _lineItem.BloodUnitFinance.ReturnCreditAmount.ToString("N");
            this.Close();
        }

		/// <summary>
		/// Handle value changed
		/// </summary>
		private void updReturnCredit_ValueChanged(object sender, System.EventArgs e)
		{
			if (_lineItem != null)
			{
				try
				{
					_lineItem.BloodUnitFinance.ReturnCreditAmount = this.updReturnCredit.Value;
					btnOK.Enabled = true;
					this.errError.SetVbecsError(updReturnCredit, ""); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					btnOK.Enabled = false;
				}
			}
		}

        /// <summary>
        /// Return the value entered by the user.
        /// </summary>
        public string ReturnCreditAmount
        {
            get
            {
                return updReturnCredit.Value.ToString();
            }
		}

		private void updReturnCredit_Leave(object sender, EventArgs e)
		{
			try
			{
				_lineItem.BloodUnitFinance.ReturnCreditAmount = this.updReturnCredit.Value;
				btnOK.Enabled = true;
				this.errError.SetVbecsError(updReturnCredit, ""); // **** 508 Compliance ***
			}
			catch(FormatException err)
			{
				btnOK.Enabled = false;
				this.errError.SetVbecsError(updReturnCredit, err.Message); // **** 508 Compliance ***
			}
		}
	}
}

